//___________________________________
//                                   \
// Rethorica Engine.  version 1.1	$Id: rethorica.js 122 2008-07-28 22:37:29Z nilton $ Fixed Subs
//___________________________________/

//Narrator.narrate(txt);
/* 

	var Rethorica= new RethoricaEngine("Rethorica",undefined,"scroll.rws","minimal.rws",true,Keys.talk,"pressCTRL.mng", undefined);
	Rethorica.InitBalloon("blue.rws",undefined,"system/topballoon.png","system/bottomballoon.png");



.TextBox()
.printTitle()
.printNarration()
.printSubtitle()
.printBalloon()

	Ethernum is both used for pause and to know the renderscript.

*/

function RethoricaEngine(objname,rfont,rwin,mwin,pauseallNPCwhentalking,continueKEY,continueMNG, Ethernum) {
	if(this instanceof RethoricaEngine == false)
		return new RethoricaEngine(objname,rfont,rwin,mwin,pauseallNPCwhentalking,continueKEY,continueMNG ,Ethernum);
	this.objname = objname;
	this.font = (typeof rfont=="object")? rfont:(typeof rfont=="string")? LoadFont(rfont): GetSystemFont();
	this.window = (typeof rwin=="object")? rwin:(typeof rwin=="string")? LoadWindowStyle(rwin): GetSystemWindowStyle();
	this.minwindow = (typeof mwin=="object")? mwin:(typeof mwin=="string")? LoadWindowStyle(mwin): GetSystemWindowStyle();

	this.active = 0;

	this.Title = new this.TextLineObj(this, "",0,0,0,false,this.font,this.minwindow,false,false,false);
	this.Balloon = new this.TextLineObj(this, "",0,0,0,'',this.font,this.minwindow,false,true,true);
	this.Narration = new this.TextLineObj(this, "",0,0,0,'',this.font,undefined,false,false,false)
	this.Subtitle = new this.TextLineObj(this, "",0,0,GetScreenHeight()-20,'',this.font,undefined,false,false,false)
	//function TextLineObj(parent, msg, seconds, x,y, sprite, font, windowstyle, fontmask, isballoon, pitch)

	this.showBalloons = 0; //show multiple balloons.
	this.Balloons = new Array(); //array to hold multiple balloons
	this.showTextbox = false;

	this.POPUPS = new Object();

	this.Freezed = new Array();//Array to hold freezed person names (workaround GetCommandQueue(name) and GetPersonScript(name,which) )
	this.Freezed.length = 0; //Seems to be nagging about this...
	this.pauseallNPCwhentalking = (pauseallNPCwhentalking!=undefined)? pauseallNPCwhentalking:true;
	this.KEY = (continueKEY)?continueKEY:KEY_CTRL;
	this.MNG = (continueMNG)?LoadAnimation(continueMNG):0;
	this.MNGdelay = 0
	this.WinBorderH = 8;
	this.WinBorderW = 8;
	this.WinMaxX = GetScreenWidth()-2*this.WinBorderW;//240
	this.WinMaxY = GetScreenHeight()-2*this.WinBorderH;//320
	this.WinMaxLn = 5;
	this.WinY = 48;
	this.UpdateAndDraw = function(){};
	this.displaying = 0;
	this.Ethernum = Ethernum;
	this.timeactive = 0; //TextBox while Render scripts stay active
}


//----------------------------------------------------------------------------//
/**
 * Sets the windowstyle margins
 */
RethoricaEngine.prototype.InitBorder= function(margin_x,margin_y){
	this.WinBorderH= margin_x;
	this.WinMaxX = GetScreenWidth() - 2*this.WinBorderH;
	this.WinBorderW= margin_y;
	this.WinMaxY = GetScreenHeight() - 2*this.WinBorderW;
}

RethoricaEngine.prototype.InitBalloon = function(windowStyle,font,topimg,bottomimg){
	this.bwindow=(typeof windowStyle=="object")?windowStyle:(typeof windowStyle=="string")?LoadWindowStyle(windowStyle):this.minwindow;
	font = (typeof font=="object")?font:(typeof font=="string")?LoadFont(font):this.font;
	this.Balloon= new this.TextLineObj(this, "",0,0,0,'',font,this.bwindow,false,true,false);
	this.btop = (typeof topimg=="object")?topimg:(typeof topimg=="string")?LoadImage(topimg):undefined;
	this.btopf=undefined;
	if(this.btop){var surf = this.btop.createSurface(); surf.flipHorizontally(); this.btopf=surf.createImage();}
	this.bbot = (typeof bottomimg=="object")?bottomimg:(typeof bottomimg=="string")?LoadImage(bottomimg):undefined;
	this.bbotf=undefined;
	if(this.bbot){var surf = this.bbot.createSurface(); surf.flipHorizontally(); this.bbotf=surf.createImage();}
	this.doBalloons = function() {};
}

RethoricaEngine.prototype.InitNarration = function(font){
	this.Narration = new this.TextLineObj(this, "",0,0,0,'', font || this.font,undefined,false,false,false)
}

//RenderMap() does not call the RenderScript!
RethoricaEngine.prototype.RenderMap = function(){
	if(this.Ethernum)
		this.Ethernum.RenderMap();
	else
		RenderMap();
}

//----------------------------------------------------------------------------//

RethoricaEngine.prototype.UpdateAndDraw_ = function() {
  this.displaying=0;
  //Process list of Persons that should be halted in their movement by adding.
  this.doFreeze();
  //Process titlebar
  this.Title.show();
  //Process Balloons
  this.Balloon.show();
  this.doBalloons();
  //Process Narration (nonblocking textbox)
  this.Narration.show();
  //Process Subtitles
  this.Subtitle.show();
 //Process Textbox

 //Cleanup if we're not doing anything
  if(this.displaying==0) this.UpdateAndDraw=function(){};
}

RethoricaEngine.prototype.clear = function() {
	this.Title.show=function(){};
	this.Balloon.show=function(){};
	this.Narration.show=function(){};
	this.Subtitle.show=function(){};
	this.doBalloons=function(){};
	this.Balloons=[];
}

RethoricaEngine.prototype.POPUPS={
	1: function(){ var X1; var X2; X1=(GetScreenWidth()-this.fontW) /(12-this.popup); X2=GetScreenWidth()-2*X1;
		if(this.window)this.window.drawWindow(X1, this.y, X2, this.fontH); },
	2: function(){ var X1; var X2; X1=(GetScreenWidth()-this.fontW) /(12-this.popup); X2=GetScreenWidth()-2*X1;
		var u= this.fontW/2/(this.popup+1); X1=GetScreenWidth()/2 - u; X2=2*u;
		if(this.window)this.window.drawWindow(X1, this.y, X2, this.fontH); },
	0: function(){ var X1; var X2; X1=(GetScreenWidth()-this.fontW) /(this.popup+1); X2=GetScreenWidth()-2*X1;
		if(this.window)this.window.drawWindow(X1, this.y, X2, this.fontH); }
	,'TopFromLeft': function(){ var X1; var X2; X1=-this.fontW-(this.fontW)/(this.popup+1); X2=X1+this.fontW;
		if(this.window)this.window.drawWindow(X1, this.y, X2, this.fontH); }
};

//----------------------------------------------------------------------------//
//Maybe split in TitleBarObj and TextBalloonObj ?
RethoricaEngine.prototype.TextLineObj = function(parent, msg, seconds, x, y, sprite, font, wins, fmsk, isballoon, pitch, poptype)
{
  this.parent = parent;
  this.done = new Function("return GetTime()>"+((seconds||3)*1000)+GetTime());
  this.msg = msg;
  this.popup = 10; //0=No popup
  this.font  = (typeof font=="object")? font : (typeof font=="string")? LoadFont(font) : GetSystemFont();
  this.fmask = (typeof fmsk=="object")? fmsk : !sprite? false : GetPersonValue(sprite, 'fontmask');
   if(this.fmask)this.font.setColorMask(this.fmask);
  this.window = (typeof wins=="object")? wins : (typeof wins=="string")? LoadWindowStyle(wins) : undefined;
  this.x = x; //horizontal offset
  this.y = y; //vertical offset
  this.sprite = sprite;
  this.follows = sprite? true:false; //Text stays in one place or follows the sprite.
  this.isballoon = isballoon;
  this.balloonX = 0;
  this.balloonY = 0;
  this.pitch = pitch;
  this.WinBorderH = this.window?8:4;
  this.WinBorderW = this.window?8:4;
  this.fontH = this.font.getHeight();
  this.fontW = this.font.getStringWidth(this.msg);
  this.WinMaxY = GetScreenHeight()-this.WinBorderH*2;//240
  this.WinMaxX = GetScreenWidth()-this.WinBorderW*2;//320
  this.maxx = this.WinMaxX-2*this.fontW-16; //text should not clip around border
  this.TextLineWinW = (this.WinMaxY-this.fontW) /2; //Center of X replaced by this.maxx
  this.TextLineWinH = this.font.getHeight();
  //this.W=this.WinMaxX;
  //this.H=this.WinMaxY;
  this.poptype = poptype || 2;

  this.reuse=function(msg,seconds,wraparound,center,offsetY,poptype){
	this.msg=msg;
  	if(poptype)this.doPopup = RethoricaEngine.prototype.POPUPS[poptype];
	if(wraparound){
 		this.txt=this.parent.WrapText(msg, this.WinMaxX,this.font); 
  		this.TextLineWinH=this.font.getHeight()*this.txt.LineCount;
		this.TextLineWinW=this.txt.maxW;
		//this.TextLineWinW=this.font.getStringWidth(this.msg);
		this.fontW=this.txt.maxW+this.WinBorderW*0;
		//this.fontW=this.font.getStringWidth(msg);
  		this.fontH=this.font.getHeight()*this.txt.LineCount+this.WinBorderH*0;
		//this.fontH=this.font.getStringHeight(msg, fontW);
  		this.maxx=GetScreenWidth()-this.WinBorderW*2-this.fontW; //text should not clip around border
	}else{
		this.txt=msg;
  		this.TextLineWinH=this.font.getHeight;
		this.TextLineWinW=this.font.getStringWidth(this.msg);
		this.fontW=this.font.getStringWidth(msg);
  		this.fontH=this.font.getHeight();
  		this.maxx=GetScreenWidth()-this.WinBorderW*2-this.fontW; //text should not clip around border
	}
	if(center){
		this.TextLineWinW = this.WinMaxX-(this.fontW/2);
		this.x=(this.WinMaxX-this.fontW)/2;
	}else{
		this.TextLineWinW = this.WinBorderW;
		this.x=this.WinBorderW;
	}

	if (typeof seconds=='string')
  		this.done= new Function("return "+seconds);
	else if (typeof seconds=='function')
  		this.done= seconds;
	else // (typeof seconds=='number')
  		this.done= new Function("return GetTime()>"+ (((seconds||3)*1000)+GetTime()) );
 	this.popup=10;
	this.show=this.show_;
	if(offsetY){
		this.y= this.WinMaxY-this.fontH;
	}else{
		this.y=this.WinBorderH;
	}

	//Abort("TODO=" + this.x+" "+this.y+" "+this.WinBorderH+" fh="+this.fontH+ " fw="+this.fontW);
  }

  this.doPopup = RethoricaEngine.prototype.POPUPS[this.poptype];

  this.show_=function(){
	if(this.popup-->0){
		++this.parent.displaying;
		this.doPopup();
  	}else{
		++this.parent.displaying;
		this.show=this.parent.showPrototype;
		this.show();
  	}
  }
  this.show=function(){};

  this.showBalloon=function(msg,bX,bY,sprite){
  	sprite=sprite||GetCurrentPerson();
  	var x=MapToScreenX(GetPersonLayer(sprite), GetPersonX(sprite))+bX;
	var y=MapToScreenY(GetPersonLayer(sprite), GetPersonY(sprite))+bY;
	var xx=x;
	fontW=this.font.getStringWidth(msg);
  	//fontH=this.font.getHeight();
  	fontH=this.font.getStringHeight(msg, fontW);
  	maxx=GetScreenWidth()-this.WinBorderW*2-fontW;
	if(x>maxx)x=maxx;
	if(this.window)this.window.drawWindow(x,y,fontW,fontH);
	if(bX<0){
		if(bY>0 && this.parent.btop)this.parent.btop.blit(xx,y-this.parent.btop.height);
		else if(bY<0 && this.parent.bbot)this.parent.bbot.blit(xx,y-this.WinBorderH+this.parent.btop.height);
	}else{
		if(bY>0 && this.parent.btopf)this.parent.btopf.blit(xx,y-this.parent.btop.height);
		else if(bY<0 && this.parent.bbotf)this.parent.bbotf.blit(xx,y-this.WinBorderH+this.parent.btop.height);
	}
	this.font.drawTextBox(x,y,fontW,fontH,0,msg);
  };

}

RethoricaEngine.prototype.showPrototype= function(sprite) {
	++this.parent.displaying;
	sprite= sprite||this.sprite;
	if(this.follows){
		this.x=MapToScreenX(GetPersonLayer(sprite), GetPersonX(sprite))+this.balloonX;
		this.xx=this.x;
		if(this.x>this.maxx)this.x=this.maxx;
		this.y=MapToScreenY(GetPersonLayer(sprite), GetPersonY(sprite))+this.balloonY;
		this.yy=this.y;
	}
	if(this.window)this.window.drawWindow(this.x,this.y,this.fontW,this.fontH);
	if(this.isballoon){
		if(this.balloonY>0 && this.parent.btop)
			this.parent.btop.blit(this.xx,this.yy-this.parent.btop.height);
		else if(this.balloonY<0 && this.parent.bbot) this.parent.bbot.blit(this.xx,this.yy+this.fontH);
	}
	this.font.drawTextBox(this.x,this.y,this.fontW,this.fontH,0,this.msg);
	if(this.done())this.show=function(){};
}

//----------------------------------------------------------------------------//

RethoricaEngine.prototype.printTitle = function(msg,end) {
	this.Title.reuse(msg,end,false,true,false);
	this.UpdateAndDraw=this.UpdateAndDraw_;
}


//maybe use ondestroy person to warn to stop printing the balloon for this person.
RethoricaEngine.prototype.printBalloon = function(msg,end,sprite,pos) {
	this.Balloon.reuse(msg,end,true,true,false);
	this.Balloon.popup = 0;
	this.Balloon.sprite = sprite;
	this.Balloon.follows = true;
	this.Balloon.isballoon = true;
	pos = pos || -1; //Default to -1:balloon is above sprite. 1:below sprite
	if(pos<0) {
		var sprite_height = GetPersonSpriteset(sprite).images[0].height;
		this.Balloon.balloonY = -16 - GetPersonSpriteset(sprite).images[0].height;
	}else
		this.Balloon.balloonY=16;
	this.Balloon.balloonX=-16; //balloon point is always to the left
	this.UpdateAndDraw = this.UpdateAndDraw_;
	this.displaying = 1;
}

RethoricaEngine.prototype.printSubtitle = function(msg,end) {
	this.Subtitle.reuse(msg,end,true,true,true);
	this.Subtitle.popup = 0;
	this.UpdateAndDraw = this.UpdateAndDraw_;
}

RethoricaEngine.prototype.printNarration = function(msg,end) {
	this.Narration.reuse(msg,end,true,true,false);
	this.Narration.popup = 0;
	this.Narration.y = this.Narration.WinBorderH + this.Narration.fontH;
	this.UpdateAndDraw = this.UpdateAndDraw_;
}

//--------------------------------------------------------------------------------------------------//
















//--------------------------------------------------------------------------------------------------//

RethoricaEngine.prototype.TextBox=function(maximize,msg,myImage){
	var screen;
	if (IsMapEngineRunning()) SetFrameRate(GetMapEngineFrameRate());
	if(!this.timeactive){
		screen = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());
	}
	var portrait =  (myImage && typeof myImage == 'string') ? LoadImage(myImage) : myImage ? myImage : false;
 	var indent = myImage? 50 : 10;
 	var done = false; 
 	var d = 170; if(maximize==0) d = 0;	//d is the popup Delay
	var size = 0;
 	var t = GetTime();
	var p = 0; //Boolean, done expanding the popup window?
	var lin = 0, pos = 0, offset = 0;
	var tm = GetTime();
	var txt = this.WrapText(msg, this.WinMaxX-indent,this.font); //auxiliary function
	var repressKEY = 0; //Make sure the window doesnt close when keeping control pressed.
	var CNlines = 0;
	++this.active;
	var cont = 0; //Continue 0:false 1:press enter to see more text 2:press enter to exit texbox

 	while(!done) {

		if(this.timeactive)
			this.RenderMap();
		else
			screen.blit(0,0);

		if((GetTime()-t) < d) {//expanding
			this.window.drawWindow(
				125 - ((this.WinMaxX-8)/2*((GetTime()-t)/d)), 
				this.WinMaxY-136, 
				64+this.WinMaxX*((GetTime()-t)/d), 
				this.WinY
			);
			continue;
		}else{ //expanded, "normal" textbox
	   		if(!p){ p=1; tm = GetTime();};
   			this.window.drawWindow(this.WinBorderW, this.WinMaxY-this.WinY, this.WinMaxX, this.WinY); //Draw the expanded window
			if(portrait) portrait.blit(this.WinBorderW, this.WinMaxY - portrait.height);

			while(GetTime()>tm) {
				if(IsKeyPressed(this.KEY))
					tm+=4; 
				else
					tm+= (txt.WrappedLines[lin+offset].charAt(pos)=="^")? 250:25; //CRTL is fast, ^ is slow.
				if( lin<this.WinMaxLn){
					pos++;
					if(pos >= txt.WrappedLines[lin+offset].length)  //FIX THIS LINE!!!
					if((lin+offset)<txt.LineCount-1){ 
						pos = 0;
						++lin;
					}else{
						cont += 1;
						tm = GetTime()+100;
						pos = txt.WrappedLines[lin+offset].length;
					}
				}
			};

			CNlines = 0;
			for(var i=offset; (i<this.WinMaxLn+offset)&&(i<txt.LineCount); ++i) {
				var RndX = (txt.WrappedLines[i].indexOf("%",0)==-1)? 0 : Math.floor(Math.random()*2);
				var RndY = (txt.WrappedLines[i].indexOf("%",0)==-1)? 0 : Math.floor(Math.random()*2);
				RndX += indent;
				//RndY +=  200-24+(this.font.getHeight()*(i-offset));
				RndY +=  this.WinMaxY -this.WinY - this.WinBorderH + (this.font.getHeight()*(i-offset));
				if(i<lin+offset) { //Draw a complete line
					CNlines++;
					this.font.drawText(RndX, RndY, txt.WrappedLines[i]);
					if(CNlines == this.WinMaxLn) {
						if(repressKEY == 0) repressKEY++;
					} //All lines displayed, so dont have to press control twice, once suffices.
				}else{ //Draw half a line of text (we're 'talking' here)
					if(i==lin+offset)
						this.font.drawText(RndX, RndY, txt.WrappedLines[i].substr(0, pos));
				}
			}
		} //#else expanded

		if (CNlines==this.WinMaxLn) {
			cont=1; //textbox full,  display "press key to continue" icon
			if (offset+CNlines==txt.LineCount) cont+=2; //All lines printed, display "press key to continue" icon
		}

		if(cont) //Display "press key to continue" icon
		{
			if(this.MNG) {
    				if(this.MNGdelay==0)this.MNGdelay=GetTime()+this.MNG.getDelay();
				this.MNG.drawFrame(GetScreenWidth()-this.MNG.width, GetScreenHeight()-this.MNG.height);
				if(this.MNGdelay<GetTime()){
					this.MNG.readNextFrame();
					this.MNGdelay=this.MNG.getDelay()+GetTime();
				}
  			}else
     				this.font.drawText(GetScreenWidth()-40, GetScreenHeight()-16+Math.floor(Math.sin(GetTime()/100)*4),"ENTER");
			if( (!IsKeyPressed(this.KEY)) && (repressKEY==1))
				repressKEY++;
		}

		if(!this.timeactive)FlipScreen(); //Show text
 
		while (AreKeysLeft()) {  
			if( this.Ethernum && this.Ethernum.checkPause() ){
				this.Ethernum.run();
				GarbageCollect();
				tm = GetTime();
				break;
			}
			switch (GetKey()) {
				case KEY_ESCAPE: done=true; break;
				case this.KEY: case KEY_ENTER:
				if(cont == 1) {
					if( (lin+offset) < txt.LineCount - 1 ){
						offset += this.WinMaxLn;
						lin = pos = cont = 0;
						CNlines = 0;
						repressKEY = 1;
					}
					tm = GetTime();
				}else if (cont>1){ 
					done=true;
				}
				break;
			}//#EndSwitch
		}//wend AreKeysLeft)_ 

	}//#EndWhile(!done)

	this.active--;

	//Now Leave the buffer ready to be FlipScreen()'ed by the engine.
	SetFrameRate(0);
	if(this.timeactive){
		UpdateMapEngine();
		this.RenderMap();
	} else {
		screen.blit(0,0);
	}

	// And empty the keyboard buffer
	while (IsKeyPressed(this.KEY)) {  }
}


//--------------------------------------------------------------------------------------


/**
 * @param {Array} Q Array of objects. Example: [ {ret:1, txt:"option1"}, {ret:2, txt:"option2"} ]
 * @param {string} msg Text message before asking
 * @param {image} myimage
 */
RethoricaEngine.prototype.QuestionBox= function(Q,msg,myImage)
{
	var portrait =  (typeof myImage == 'string') ? LoadImage(myImage) : myImage ? myImage : false;
	var indent=50;
	if(myImage == '') indent = 10;
	var done=false; 
	var selected=0;
	//var p=0;
	var lin=0, pos=0, offset=0;
	var tm = GetTime();
	var txt = this.WrapText(msg, this.WinMaxX-indent,this.font);

	while (!done) {
		//UpdateMapEngine();
		this.RenderMap();

		this.window.drawWindow(this.WinBorderW, this.WinMaxY - this.WinBorderH - txt.maxH, this.WinMaxX, txt.maxH+2*this.WinBorderH); 
		if(myImage) portrait.blit(this.WinBorderW, this.WinMaxY- txt.maxH - portrait.height);

		for(var i=offset, l=this.WinMaxLn+offset; i<l ; i++) {
			if(txt.WrappedLines[i])
				this.font.drawText(this.WinBorderW+indent, this.WinMaxY-1*this.WinBorderH-txt.maxH + i*this.font.getHeight(),txt.WrappedLines[i]);
		}
		for(var i=txt.LineCount, l=Q.length+txt.LineCount; i<l ; i++) {
			this.font.drawText(this.WinBorderW+indent, 
			this.WinMaxY-1*this.WinBorderH + (this.font.getHeight()*(i-1)),
			" "+i+" "+Q[i-txt.LineCount].txt);
		}
		this.font.drawText(this.WinBorderW+indent+Math.sin(GetTime() / 100)*2, 
			this.WinMaxY-1*this.WinBorderH + (this.font.getHeight()*(txt.LineCount+selected-offset-1)),
			">");

		while(AreKeysLeft()) {  
			switch(GetKey()) {
				case KEY_ESCAPE: done=true; break;
				case KEY_DOWN:   if(selected<Q.length-1) selected++;else selected=0; break;
				case KEY_UP:     if(selected>0) selected--;else selected=Q.length-1; break;
				case this.KEY: 
				case KEY_ENTER: return Q[selected].ret; break;
			}
		}
		FlipScreen(); //Show text
	}

	//Now Leave the buffer ready to be FlipScreen()'ed by the engine.
	UpdateMapEngine();
	this.RenderMap();

	return -1; 
}



//--------------------------------------------------------------------------------------
RethoricaEngine.prototype.WrapText=function(say, WrapPixels,font) //pass it a string and number of pixels to wrap to, and it returns with a text object. Based on code from ??????
{
	var T = {
		WrappedLines: new Array(),
		LineCount: 0, // Amount of lines in the wrapped text;
		maxW: 0, // Maximum width of the wrapped lines (in pixels);
		maxH: 0, // Maximum height of the wrapped lines (in pixels);
	};
	var c = 0; //current "start" location.
	var p = 0; //current character being looked at.
	var l = say.length;
	var done=false;
	//do the wordwrapping.
	while(!done)  {
		if(p==l){ 
			T.WrappedLines[T.LineCount++]=say.substring(c, p); 
			done=true; 
		} else{
			if(say.substring(p, p+1)=="\n"){
				T.WrappedLines[T.LineCount++] = say.substring(c, ++p);
				c=p;
			} else if(font.getStringWidth(say.substring(c, p))>=WrapPixels){
				while(say.substr(p-1, 1)!=" ")
					p--;
				T.WrappedLines[T.LineCount++] = say.substring(c, p);
				c=p;
			}
		}
		p++;
	}
	for(var i=0, l=T.LineCount ; i<l ; i++){
		if(T.maxW<font.getStringWidth(T.WrappedLines[i])) T.maxW = font.getStringWidth(T.WrappedLines[i]);
	}
	T.maxH = T.LineCount * font.getHeight();
	return T; //returns the wrapped text object.
}


//----------------------------------------------------------------------------//


RethoricaEngine.prototype.Freeze = function(name) {
	this.Freezed[this.Freezed.length]=name;
	this.doFreeze = function() {
		var i=this.Freezed.length-1;
	do{
		if(IsCommandQueueEmpty(this.Freezed[i]))
		QueuePersonCommand(this.Freezed[i], COMMAND_WAIT, false);
	}while(i--);
	};
}

//----------------------------------------------------------------------------//

RethoricaEngine.prototype.UnFreeze = function(name) {
	var i=this.Freezed.length-1;
	if(i<0) return;
	do{ if(this.Freezed[i]==name) {this.Freezed[i]=this.Freezed[this.Freezed.length-1];--this.Freezed.length} } while(i--);
	GarbageCollect();
	if(this.Freezed.length=0) this.doFreeze = function() {};
}

RethoricaEngine.prototype.doFreeze  = function() {}
RethoricaEngine.prototype.doBalloons= function() {}

//----------------------------------------------------------------------------//

RethoricaEngine.prototype.addBalloon = function(sprite) {
	this.Balloons[this.Balloons.length]=sprite;
	this.doBalloons = function() { var i=this.Balloons.length-1; if(i<0)return; this.displaying++; do{ 
		sprite=this.Balloons[i];
		bX= GetPersonValue(sprite,"bX")||-16;
		bY= GetPersonValue(sprite,"bY")||16;
		msg=GetPersonValue(sprite,"bmsg")
		fra=GetPersonValue(sprite,"bfra");
		if(fra==0)this.rmBalloon(sprite); else SetPersonValue(sprite,"bfra",--fra);
		this.Balloon.showBalloon(msg,bX,bY,sprite);
		}while(i--); 
	};
	this.UpdateAndDraw=this.UpdateAndDraw_;
}

RethoricaEngine.prototype.rmBalloon = function(sprite) {
	var i=this.Balloons.length-1;
	if(i<0) return;
	do{ 
	if(this.Balloons[i]==sprite) {
		if(this.Balloons.length==1)this.Balloons=new Array();
		else this.Balloons[i]=this.Balloons.pop();
		i=0;
	} 
	} while(i--);
	GarbageCollect();
	if(this.Balloons.length==0) this.doBalloons = function() {};
}



//===================
function BorderAroundFont(fnt,color){


}
